<?php

namespace App\Http\Middleware;

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Auth\LoginController;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CanAttendance
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()){
            if(Auth::user()->role == 3 || Auth::user()->role == 1 ||Auth::user()->role==0)
                return $next($request);
            else{
                $login = new AuthController();
                $login->logout();
                return redirect()->back()->with(['error' => 'ليس لديك الصلاحية لدخول الصفحة ']);
            }
        }

        return redirect()->route('login')->with(['error' => 'عذرا لا تملك الصلاحية لدخول هذه الصفحة يرجى تسجيل الدخول او انشاء حساب']);
    }
}
